<?php

namespace App\Models\SubDsipatch;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubDsipatch extends Model 
{

    protected $table = 'sub_dispatches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('order_id', 'price_basis_id', 'freight_charges');
    protected $visible = array('order_id', 'price_basis_id', 'freight_charges');

    public function priceBasis()
    {
        return $this->belongsTo('PriceBasis');
    }

    public function orderItems()
    {
        return $this->morphMany('OrderItem');
    }

    public function transportationDetail()
    {
        return $this->hasOne('Transportation');
    }

    public function vendors()
    {
        return $this->hasMany('Vendor');
    }

}